/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklist;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Locale;

public class ManagerService
extends Tasklet {
    private static final String TRACE_MASKT = "XTKLSRVT";
    public static final short SERVER_RUN_ERROR = 2353;
    static final String SERVICE_OPERATION = "operation";
    static final String OPERATION_IS_PRIVILEGED = "isPrivileged";
    static final String RESPONSE_PRIVILEGED = "privileged";
    static final String OPERATION_TRANSLATE_TARGETS = "translateTargets";
    static final String REQUEST_TARGETS = "targets";
    static final String RESPONSE_TARGETS = "targets";

    public void init(Object initData) throws TaskletException {
    }

    public void service(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        taskletResponse.noAction();
        if (taskletRequest.isInitialRequest()) {
            return;
        }
        String operation = (String)taskletRequest.getData(SERVICE_OPERATION);
        if (operation == null) {
            throw new TaskletException("Missing operation");
        }
        if (operation.equals(OPERATION_IS_PRIVILEGED)) {
            this.isPrivileged(taskletRequest, taskletResponse);
        } else if (operation.equals(OPERATION_TRANSLATE_TARGETS)) {
            this.translateTargets(taskletRequest, taskletResponse);
        } else {
            throw new TaskletException("Unknown operation \"" + operation + '\"');
        }
    }

    private void isPrivileged(TaskletRequest taskletRequest, TaskletResponse taskletResponse) {
        Trace.trace(TRACE_MASKT, "User.getUser() returns " + User.getUser());
        taskletResponse.setData(RESPONSE_PRIVILEGED, new Boolean(User.getUser().hasAuth("base.rolegroup.pedebug")));
    }

    private void translateTargets(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        ObjectId[] targets = (ObjectId[])taskletRequest.getData("targets");
        if (targets == null) {
            throw new TaskletException("Missing targets");
        }
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        String[] names = new String[targets.length];
        Locale clientLocale = UserContext.getCurrentUserContext().getLocale();
        for (int i = 0; i < targets.length; ++i) {
            UIInfo uiInfo = (UIInfo)mom.getProperty(targets[i], "UIInfo");
            if (uiInfo == null) continue;
            names[i] = uiInfo.getName(clientLocale);
        }
        taskletResponse.setData("targets", names);
    }

    public void logException(Throwable throwable) {
        FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "TaskListTask");
        new FrameworkLog(classLogInfo, 2353, throwable).log();
    }
}

